/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    usart.c
  * @brief   This file provides code for the configuration
  *          of the USART instances.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "bsp_uart.h"

UART_HandleTypeDef huart1;

// λ
static uint8_t usart_rx_buf[USART_RX_BUF_SIZE];
static volatile uint16_t usart_rx_head = 0;
static volatile uint16_t usart_rx_tail = 0;

/* USART1 init function */

void bsp_InitUart(void)
{

  /* USER CODE BEGIN USART1_Init 0 */

  /* USER CODE END USART1_Init 0 */

  /* USER CODE BEGIN USART1_Init 1 */

  /* USER CODE END USART1_Init 1 */
  huart1.Instance = USART1;
  huart1.Init.BaudRate = 115200;
  huart1.Init.WordLength = UART_WORDLENGTH_8B;
  huart1.Init.StopBits = UART_STOPBITS_1;
  huart1.Init.Parity = UART_PARITY_NONE;
  huart1.Init.Mode = UART_MODE_TX_RX;
  huart1.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  huart1.Init.OverSampling = UART_OVERSAMPLING_16;
  if (HAL_UART_Init(&huart1) != HAL_OK)
  {
    Error_Handler();
  }
	
  // ýж
	HAL_UART_Receive_IT(&huart1, &usart_rx_buf[usart_rx_head], 1);
	
	// NVIC
	HAL_NVIC_SetPriority(USART1_IRQn, 0, 0);
	HAL_NVIC_EnableIRQ(USART1_IRQn);
	
	// ʼ
	usart_rx_head = 0;
	usart_rx_tail = 0;
	memset(usart_rx_buf, 0, USART_RX_BUF_SIZE);

}

void HAL_UART_MspInit(UART_HandleTypeDef* uartHandle)
{

  GPIO_InitTypeDef GPIO_InitStruct = {0};
  if(uartHandle->Instance==USART1)
  {
  /* USER CODE BEGIN USART1_MspInit 0 */

  /* USER CODE END USART1_MspInit 0 */
    /* USART1 clock enable */
    __HAL_RCC_USART1_CLK_ENABLE();
    __HAL_RCC_GPIOA_CLK_ENABLE();
    /**USART1 GPIO Configuration
    PA9     ------> USART1_TX
    PA10     ------> USART1_RX
    */
    GPIO_InitStruct.Pin = GPIO_PIN_9;
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = GPIO_PIN_10;
    GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* USER CODE BEGIN USART1_MspInit 1 */

  /* USER CODE END USART1_MspInit 1 */
  }
}

void HAL_UART_MspDeInit(UART_HandleTypeDef* uartHandle)
{
  if(uartHandle->Instance==USART1)
  {
    /* Peripheral clock disable */
    __HAL_RCC_USART1_CLK_DISABLE();

    /**USART1 GPIO Configuration
    PA9     ------> USART1_TX
    PA10     ------> USART1_RX
    */
    HAL_GPIO_DeInit(GPIOA, GPIO_PIN_9|GPIO_PIN_10);
  }
}

#if 1
void USART1_Reinit(void)
{
    // 1. GPIO
    GPIO_InitTypeDef GPIO_InitStruct = {0};
    
    __HAL_RCC_GPIOA_CLK_ENABLE();
    __HAL_RCC_USART1_CLK_ENABLE();
    
    // TX (PA9)
    GPIO_InitStruct.Pin = GPIO_PIN_9;
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    // RX (PA10)
    GPIO_InitStruct.Pin = GPIO_PIN_10;
    GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    // 2. ³ʼ
    huart1.Instance = USART1;
    huart1.Init.BaudRate = 115200;
    huart1.Init.WordLength = UART_WORDLENGTH_8B;
    huart1.Init.StopBits = UART_STOPBITS_1;
    huart1.Init.Parity = UART_PARITY_NONE;
    huart1.Init.Mode = UART_MODE_TX_RX;
    huart1.Init.HwFlowCtl = UART_HWCONTROL_NONE;
    huart1.Init.OverSampling = UART_OVERSAMPLING_16;
    HAL_UART_Init(&huart1);

    // 3. ж
    HAL_NVIC_SetPriority(USART1_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(USART1_IRQn);
    
    // 4. ж
    HAL_UART_Receive_IT(&huart1, &usart_rx_buf[usart_rx_head], 1);
    
    // 5. û״̬
    usart_rx_head = 0;
    usart_rx_tail = 0;
    memset(usart_rx_buf, 0, USART_RX_BUF_SIZE);
}

void USART1_EnterSleep(void)
{
    // 洮״̬
    HAL_UART_AbortReceive_IT(&huart1);
    HAL_NVIC_DisableIRQ(USART1_IRQn);
    
    // رմʱ
    __HAL_RCC_USART1_CLK_DISABLE();
    __HAL_RCC_GPIOA_CLK_DISABLE();
}

#endif

// ַ
void USART1_SendString(const char *str)
{
    HAL_UART_Transmit(&huart1, (uint8_t*)str, strlen(str), HAL_MAX_DELAY);
}

// 
void USART1_SendData(uint8_t *data, uint16_t size)
{
    HAL_UART_Transmit(&huart1, data, size, HAL_MAX_DELAY);
}

// ӻλȡ
uint16_t USART1_ReceiveData(uint8_t *buffer, uint16_t max_len)
{
    uint16_t count = 0;
    
    while (usart_rx_tail != usart_rx_head && count < max_len) {
        buffer[count++] = usart_rx_buf[usart_rx_tail];
        usart_rx_tail = (usart_rx_tail + 1) % USART_RX_BUF_SIZE;
    }
    
    return count;
}

// ȡջе
uint16_t USART1_GetRxCount(void)
{
    if (usart_rx_head >= usart_rx_tail) {
        return usart_rx_head - usart_rx_tail;
    } else {
        return USART_RX_BUF_SIZE - usart_rx_tail + usart_rx_head;
    }
}

// սջ
void USART1_ClearRxBuffer(void)
{
    usart_rx_head = 0;
    usart_rx_tail = 0;
}

// USART1жϴ
void USART1_IRQHandler(void)
{
    HAL_UART_IRQHandler(&huart1);
}

// HALɻص
void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{
    if (huart->Instance == USART1) {
        // »ָ
        usart_rx_head = (usart_rx_head + 1) % USART_RX_BUF_SIZE;
        
        // ɵ
        if (usart_rx_head == usart_rx_tail) {
            usart_rx_tail = (usart_rx_tail + 1) % USART_RX_BUF_SIZE;
        }
        
        // һַ
        HAL_UART_Receive_IT(huart, &usart_rx_buf[usart_rx_head], 1);
    }
}

/*
*********************************************************************************************************
*	  : fputc
*	˵: ضputcʹprintfӴ1ӡ
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
int fputc(int ch, FILE *f)
{
#if 0	/* ҪprintfַͨжFIFOͳȥprintf */
	comSendChar(COM1, ch);
	
	return ch;
#else	/* ʽÿַ,ȴݷ */
	/* дһֽڵUSART1 */
//	USART1->DR = ch;
//	
//	/* ȴͽ */
//	while((USART1->SR & USART_SR_TC) == 0)
//	{}
    
    uint8_t data = ch;
    
    HAL_UART_Transmit(&huart1, &data, 1, HAL_MAX_DELAY);
	
	return ch;
#endif
}

/*
*********************************************************************************************************
*	  : fgetc
*	˵: ضgetcʹgetcharӴ1
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
int fgetc(FILE *f)
{

#if 0	/* ӴڽFIFOȡ1, ֻȡݲŷ */
	uint8_t ucData;

	while(comGetChar(COM1, &ucData) == 0);

	return ucData;
#else
	/* ȴյ */
	while((USART1->SR & USART_SR_RXNE) == 0)
	{}

	return (int)USART1->DR;
#endif
}
/* USER CODE END 1 */
