/**
  ******************************************************************************
  * ļ    bsp_key.h
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/
#ifndef __BSP_KEY_H
#define __BSP_KEY_H

/* ӦóĹ */


#define KEY2_DOWN_U		KEY_2_DOWN		    /*  */
#define KEY2_UP_U		KEY_2_UP
#define KEY2_LONG_U		KEY_2_LONG

#define KEY3_DOWN_L		KEY_3_DOWN		    /*  */
#define KEY3_UP_L		KEY_3_UP
#define KEY3_LONG_L		KEY_3_LONG


#define KEY4_DOWN_OK	KEY_4_DOWN		    /* ok */
#define KEY4_UP_OK		KEY_4_UP
#define KEY4_LONG_OK	KEY_4_LONG

#define KEY5_DOWN_R		KEY_5_DOWN		    /*  */
#define KEY5_UP_R		KEY_5_UP
#define KEY5_LONG_R		KEY_5_LONG

#define KEY6_DOWN_D		KEY_6_DOWN		    /*  */
#define KEY6_UP_D		KEY_6_UP
#define KEY6_LONG_D		KEY_6_LONG







/* ID, Ҫbsp_KeyState()ڲ */
typedef enum
{
	KID_K2 = 0,
	KID_K3,
	KID_K4,
	KID_K5,
    KID_K6
}KEY_ID_E;

/*
	˲ʱ50ms, λ10ms
	ֻ⵽50ms״̬ΪЧͰ¼
	ʹ·Ӳ˲˲ҲԱ֤ɿؼ⵽¼
*/
#define KEY_FILTER_TIME   5
#define KEY_LONG_TIME     100			/* λ10ms 1룬Ϊ¼ */

/*
	ÿӦ1ȫֵĽṹ
*/
typedef struct
{
	/* һָ룬ָжϰַµĺ */
	uint8_t (*IsKeyDownFunc)(void); /* µжϺ,1ʾ */

	uint8_t  Count;			/* ˲ */
	uint16_t LongCount;		/*  */
	uint16_t LongTime;		/* ³ʱ, 0ʾⳤ */
	uint8_t  State;			/* ǰ״̬»ǵ */
	uint8_t  RepeatSpeed;	/*  */
	uint8_t  RepeatCount;	/*  */
}KEY_T;

/*
	ֵ, 밴´ʱÿİ¡ͳ¼

	Ƽʹenum, #defineԭ
	(1) ֵ,˳ʹ뿴
	(2) ɰǱֵظ
*/
typedef enum
{
	KEY_NONE = 0,			/* 0 ʾ¼ */

	KEY_2_DOWN,				/* 2 */
	KEY_2_UP,				/* 2 */
	KEY_2_LONG,				/* 2 */

	KEY_3_DOWN,				/* 3 */
	KEY_3_UP,				/* 3 */
	KEY_3_LONG,				/* 3 */

	KEY_4_DOWN,				/* 4 */
	KEY_4_UP,				/* 4 */
	KEY_4_LONG,				/* 4 */

	KEY_5_DOWN,				/* 5 */
	KEY_5_UP,				/* 5 */
	KEY_5_LONG,				/* 5 */

	KEY_6_DOWN,				/* 6 */
	KEY_6_UP,				/* 6 */
	KEY_6_LONG,				/* 6 */

}KEY_ENUM;

/* FIFOõ */
#define KEY_FIFO_SIZE	10
typedef struct
{
	uint8_t Buf[KEY_FIFO_SIZE];		/* ֵ */
	uint8_t Read;					/* ָ1 */
	uint8_t Write;					/* дָ */
	uint8_t Read2;					/* ָ2 */
}KEY_FIFO_T;

/* ⲿõĺ */
void bsp_InitKey(void);
void bsp_KeyScan10ms(void);
void bsp_PutKey(uint8_t _KeyCode);
uint8_t bsp_GetKey(void);
uint8_t bsp_GetKey2(void);
uint8_t bsp_GetKeyState(KEY_ID_E _ucKeyID);
void bsp_SetKeyParam(uint8_t _ucKeyID, uint16_t _LongTime, uint8_t  _RepeatSpeed);
void bsp_ClearKey(void);

#endif

/****** Copyright (C) 2025-2050 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved. *******/
