/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "bsp.h"


/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);

/*
*********************************************************************************************************
*	  : bsp_Init
*	˵: ʼеӲ豸úCPUĴļĴʼһЩȫֱֻҪһ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_Init(void)
{
		/* Reset of all peripherals, Initializes the Flash interface and the Systick. */
		HAL_Init();
		/* Configure the system clock */
		SystemClock_Config();

		HAL_NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);

		/* Initialize all configured peripherals */
		bsp_InitTimer();  	
		bsp_InitUart();
		bsp_InitLed();
		/* USER CODE BEGIN 2 */
		// ʼFlash
		if (Flash_Init() != HAL_OK) {
				printf("Flash initialization failed!\r\n");
				while(1);
		}

}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.HSEPredivValue = RCC_HSE_PREDIV_DIV1;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL9;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

/*
*********************************************************************************************************
*	  : bsp_Idle
*	˵: ʱִеĺһforwhileѭҪ CPU_IDLE() ñ
*			 ȱʡΪղûιCPUģʽĹܡ
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_Idle(void)
{
	/* --- ι */

	/* --- CPUߣSystickʱжϻѻжϻ */

	/*  emWin ͼο⣬ԲͼοҪѯ */
	//GUI_Exec();

	/*  uIP Э飬Բuipѯ */
	//TOUCH_CapScan();
}

