/**
  ******************************************************************************
  * ļ    bsp_dwt.c
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/
#include "bsp.h"



/*
*********************************************************************************************************
*                                             Ĵ
*********************************************************************************************************
*/
#define  DEM_CR_TRCENA               (1 << 24)
#define  DWT_CR_CYCCNTENA            (1 <<  0)


/*
*********************************************************************************************************
*	  : bsp_InitDWT
*	˵: ʼDWT. ú bsp_Init() á
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_InitDWT(void)
{
	DEM_CR         |= (unsigned int)DEM_CR_TRCENA;   
	DWT_CYCCNT      = (unsigned int)0u;
	DWT_CR         |= (unsigned int)DWT_CR_CYCCNTENA;
}

#if 0  /* bsp_timer.cѾʵ */
/*
*********************************************************************************************************
*	  : bsp_DelayMS
*	˵: ΪõײڴRTOSиõļ
*             רһʽӳٺڵײmsӳҪڳʼӰʵʱԡ
*	    : n ӳٳȣλ1 ms
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_DelayMS(uint32_t _ulDelayTime)
{
	bsp_DelayUS(1000*_ulDelayTime);
}

/*
*********************************************************************************************************
*	  : bsp_DelayUS
*	˵: ʱCPUڲʵ֣32λ
*             	OSSchedLock(&err);
*				bsp_DelayUS(5);
*				OSSchedUnlock(&err); ʵǷҪӵѡж
*	    : _ulDelayTime  ӳٳȣλ1 us
*	  ֵ: 
*   ˵    : 1. Ƶ168MHz£32λ2^32/168000000 = 25.565
*                ʹñӳٵĻӳ1¡  
*             2. ʵͨʾԣ΢ӳٺʵʵʶ0.25usҵʱ䡣
*             ݲ
*             1. MDK5.15Żȼ0, ͬMDKŻȼûӰ졣
*             2. STM32F407IGT6
*             3. Է
*				 GPIOI->BSRRL = GPIO_Pin_8;
*				 bsp_DelayUS(10);
*				 GPIOI->BSRRH = GPIO_Pin_8;
*             -------------------------------------------
*                                 ʵִ
*             bsp_DelayUS(1)          1.2360us
*             bsp_DelayUS(2)          2.256us
*             bsp_DelayUS(3)          3.256us
*             bsp_DelayUS(4)          4.256us
*             bsp_DelayUS(5)          5.276us
*             bsp_DelayUS(6)          6.276us
*             bsp_DelayUS(7)          7.276us
*             bsp_DelayUS(8)          8.276us
*             bsp_DelayUS(9)          9.276us
*             bsp_DelayUS(10)         10.28us
*            3. 32λ޷ȡĽٸֵ32λ޷ȻȷĻȡֵ
*              A,B,C32λ޷
*              A > B  ôA - B = Cܺ⣬ȫû
*              A < B  ôA - B = C Cֵ0xFFFFFFFF - B + A + 1һҪرע⣬ڱ
*********************************************************************************************************
*/
void bsp_DelayUS(uint32_t _ulDelayTime)
{
    uint32_t tCnt, tDelayCnt;
	uint32_t tStart;
		
	tStart = DWT_CYCCNT;                                     /* սʱļֵ */
	tCnt = 0;
	tDelayCnt = _ulDelayTime * (SystemCoreClock / 1000000);	 /* ҪĽ */ 		      

	while(tCnt < tDelayCnt)
	{
		tCnt = DWT_CYCCNT - tStart; /* Уһ32λ¼Ȼȷ */	
	}
}

void bsp_DelayDWT(uint32_t _ulDelayTime)
{
    uint32_t tCnt, tDelayCnt;
	uint32_t tStart;
		
	tCnt = 0;
	tDelayCnt = _ulDelayTime;	 /* ҪĽ */ 		      
	tStart = DWT_CYCCNT;         /* սʱļֵ */
	
	while(tCnt < tDelayCnt)
	{
		tCnt = DWT_CYCCNT - tStart; /* Уһ32λ¼Ȼȷ */	
	}
}
#endif
/****** Copyright (C) 2025-2050 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved. *******/
