#include "bsp_flash.h"

// Flashʼ
HAL_StatusTypeDef Flash_Init(void)
{
    // FlashǷѽ
    if (READ_BIT(FLASH->CR, FLASH_CR_LOCK) != RESET) {
        // Flash
        HAL_FLASH_Unlock();
    }
    
    // д־
    __HAL_FLASH_CLEAR_FLAG(FLASH_FLAG_BSY | FLASH_FLAG_EOP | FLASH_FLAG_PGERR | FLASH_FLAG_WRPERR);
    
    return HAL_OK;
}

// ָҳ
HAL_StatusTypeDef Flash_Erase_Page(uint32_t page_address)
{
    HAL_StatusTypeDef status;
    FLASH_EraseInitTypeDef EraseInitStruct;
    uint32_t PageError = 0;
    
    // ַǷЧΧ
    if (page_address < FLASH_USER_START_ADDR || page_address > FLASH_USER_END_ADDR) {
        return HAL_ERROR;
    }
    
    // Flash
    HAL_FLASH_Unlock();
    
    // ò
    EraseInitStruct.TypeErase = FLASH_TYPEERASE_PAGES;
    EraseInitStruct.PageAddress = page_address;
    EraseInitStruct.NbPages = 1; // 1ҳ
    
    // ִв
    status = HAL_FLASHEx_Erase(&EraseInitStruct, &PageError);
    
    // Flash
    HAL_FLASH_Lock();
    
    return status;
}

// дݣ԰Ϊλ
HAL_StatusTypeDef Flash_Write(uint32_t address, uint16_t *data, uint32_t size)
{
    HAL_StatusTypeDef status = HAL_OK;
    uint32_t i;
    
    // ַǷЧΧ
    if (address < FLASH_USER_START_ADDR || address + size * 2 > FLASH_USER_END_ADDR) {
        return HAL_ERROR;
    }
    
    // Flash
    HAL_FLASH_Unlock();
    
    // д
    for (i = 0; i < size; i++) {
        status = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD, address, data[i]);
        if (status != HAL_OK) {
            break;
        }
        address += 2; // ַ2ֽ
    }
    
    // Flash
    HAL_FLASH_Lock();
    
    return status;
}

// ȡݣ԰Ϊλ
void Flash_Read(uint32_t address, uint16_t *data, uint32_t size)
{
    uint32_t i;
    
    for (i = 0; i < size; i++) {
        data[i] = *(__IO uint16_t*)(address);
        address += 2;
    }
}

// д
HAL_StatusTypeDef Flash_Write_Data(uint32_t address, void *data, uint32_t size)
{
	#if 1
    // ȷݴС2ıֶ룩
    if (size % 2 != 0) {
        return HAL_ERROR;
    }
    
    return Flash_Write(address, (uint16_t*)data, size / 2);
	#else
		HAL_StatusTypeDef status = HAL_OK;
		// ȷsize2ıֶ룩
    if (size % 2 != 0) {
        // С
        size = (size + 1) & ~1; // ȡ2ı
    }
    
    // д
    HAL_FLASH_Unlock();
    for (uint32_t i = 0; i < size; i += 2) {
        uint16_t halfword = *((uint16_t*)((uint8_t*)data + i));
        status = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD, address + i, halfword);
				if (status != HAL_OK) {
            break;
        }
    }
    HAL_FLASH_Lock();
		return status;
	#endif
}

// ȡ
void Flash_Read_Data(uint32_t address, void *data, uint32_t size)
{
    // ȷݴС2ıֶ룩
    if (size % 2 != 0) {
        return;
    }
    
    Flash_Read(address, (uint16_t*)data, size / 2);
}

// FlashǷΪգȫΪ0xFF
bool Flash_Is_Empty(uint32_t address, uint32_t size)
{
    for (uint32_t i = 0; i < size; i++) {
        if (*(__IO uint8_t*)(address + i) != 0xFF) {
            return false;
        }
    }
    return true;
}

