/**
  ******************************************************************************
  * ļ    bsp_key.c
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/
#include "bsp.h"

#define HARD_KEY_NUM	    5	   						/* ʵ尴 */
#define KEY_COUNT   	 	(HARD_KEY_NUM)	            /* 5*/

/* ʹGPIOʱ */
#define ALL_KEY_GPIO_CLK_ENABLE() {	\
		__HAL_RCC_GPIOB_CLK_ENABLE();	\
	};

/* ζGPIO */
typedef struct
{
	GPIO_TypeDef* gpio;
	uint16_t pin;
	uint8_t ActiveLevel;	/* ƽ */
}X_GPIO_T;

/* GPIOPIN */
static const X_GPIO_T s_gpio_list[HARD_KEY_NUM] = {
    {GPIOB, GPIO_PIN_2, 0},		/* KEY_UP */
	{GPIOB, GPIO_PIN_0, 0},		/* KEY_LEFT */
	{GPIOB, GPIO_PIN_1, 0},	    /* KEY_OK */
	{GPIOB, GPIO_PIN_4, 0},		/* KEY_RIGHT */
	{GPIOB, GPIO_PIN_3, 0},		/* KEY_DOWN */	
};	

/* һ꺯򻯺 
	жGPIOǷЧ
*/
static KEY_T s_tBtn[KEY_COUNT] = {0};
static KEY_FIFO_T s_tKey;		/* FIFO,ṹ */

static void bsp_InitKeyVar(void);
static void bsp_InitKeyHard(void);
static void bsp_DetectKey(uint8_t i);

#define KEY_PIN_ACTIVE(id)	

volatile uint8_t flag_key_short_press;
volatile uint8_t flag_key_long_press;

/*
*********************************************************************************************************
*	  : KeyPinActive
*	˵: жϰǷ
*	    : 
*	  ֵ: ֵ1 ʾ(ͨ0ʾδ£ͷţ
*********************************************************************************************************
*/
static uint8_t KeyPinActive(uint8_t _id)
{
	uint8_t level;
	
	if ((s_gpio_list[_id].gpio->IDR & s_gpio_list[_id].pin) == 0)
	{
		level = 0;
	}
	else
	{
		level = 1;
	}

	if (level == s_gpio_list[_id].ActiveLevel)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/*
*********************************************************************************************************
*	  : IsKeyDownFunc
*	˵: жϰǷ¡ϼ֡¼¡
*	    : 
*	  ֵ: ֵ1 ʾ(ͨ0ʾδ£ͷţ
*********************************************************************************************************
*/
static uint8_t IsKeyDownFunc(uint8_t _id)
{
	/* ʵ嵥 */
	if (_id < HARD_KEY_NUM)
	{
		uint8_t i;
		uint8_t count = 0;
		uint8_t save = 255;
		
		/* жм */
		for (i = 0; i < HARD_KEY_NUM; i++)
		{
			if (KeyPinActive(i)) 
			{
				count++;
				save = i;
			}
		}
		
		if (count == 1 && save == _id)
		{
			return 1;	/* ֻ1ʱЧ */
		}		

		return 0;
	}

	return 0;
}

/*
*********************************************************************************************************
*	  : bsp_InitKey
*	˵: ʼ. ú bsp_Init() á
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_InitKey(void)
{
	bsp_InitKeyVar();		/* ʼ */
	bsp_InitKeyHard();		/* ʼӲ */
}

/*
*********************************************************************************************************
*	  : bsp_InitKeyHard
*	˵: ðӦGPIO
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
static void bsp_InitKeyHard(void)
{	
	GPIO_InitTypeDef gpio_init;
	uint8_t i;

	/* 1GPIOʱ */
	ALL_KEY_GPIO_CLK_ENABLE();
	
	/* 2еİGPIOΪģʽ(ʵCPUλ״̬) */
	gpio_init.Mode = GPIO_MODE_INPUT;   			/*  */
	gpio_init.Pull = GPIO_PULLUP;//GPIO_NOPULL;                 /* 費ʹ */
	gpio_init.Speed = GPIO_SPEED_FREQ_VERY_HIGH;  /* GPIOٶȵȼ */
	
	for (i = 0; i < HARD_KEY_NUM; i++)
	{
		gpio_init.Pin = s_gpio_list[i].pin;
		HAL_GPIO_Init(s_gpio_list[i].gpio, &gpio_init);	
	}
}

/*
*********************************************************************************************************
*	  : bsp_InitKeyVar
*	˵: ʼ
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
static void bsp_InitKeyVar(void)
{
	uint8_t i;

	/* ԰FIFOдָ */
	s_tKey.Read = 0;
	s_tKey.Write = 0;
	s_tKey.Read2 = 0;

	/* ÿṹԱһȱʡֵ */
	for (i = 0; i < KEY_COUNT; i++)
	{
		s_tBtn[i].LongTime = KEY_LONG_TIME;			    /* ʱ 0 ʾⳤ¼ */
		s_tBtn[i].Count = KEY_FILTER_TIME / 2;		    /* Ϊ˲ʱһ */
		s_tBtn[i].State = 0;							/* ȱʡ״̬0Ϊδ */
		s_tBtn[i].RepeatSpeed = 0;						/* ٶȣ0ʾ֧ */
		s_tBtn[i].RepeatCount = 0;						/*  */
	}

	/* ҪĳĲڴ˵¸ֵ */
	
}

/*
*********************************************************************************************************
*	  : bsp_PutKey
*	˵: 1ֵѹ밴FIFOģһ
*	    :  _KeyCode : 
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_PutKey(uint8_t _KeyCode)
{
	s_tKey.Buf[s_tKey.Write] = _KeyCode;

	if (++s_tKey.Write  >= KEY_FIFO_SIZE)
	{
		s_tKey.Write = 0;
	}
}

/*
*********************************************************************************************************
*	  : bsp_GetKey
*	˵: ӰFIFOȡһֵ
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
uint8_t bsp_GetKey(void)
{
	uint8_t ret;

	if (s_tKey.Read == s_tKey.Write)
	{
		return KEY_NONE;
	}
	else
	{
		ret = s_tKey.Buf[s_tKey.Read];

		if (++s_tKey.Read >= KEY_FIFO_SIZE)
		{
			s_tKey.Read = 0;
		}
		return ret;
	}
}

/*
*********************************************************************************************************
*	  : bsp_GetKey2
*	˵: ӰFIFOȡһֵĶָ롣
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
uint8_t bsp_GetKey2(void)
{
	uint8_t ret;

	if (s_tKey.Read2 == s_tKey.Write)
	{
		return KEY_NONE;
	}
	else
	{
		ret = s_tKey.Buf[s_tKey.Read2];

		if (++s_tKey.Read2 >= KEY_FIFO_SIZE)
		{
			s_tKey.Read2 = 0;
		}
		return ret;
	}
}

/*
*********************************************************************************************************
*	  : bsp_GetKeyState
*	˵: ȡ״̬
*	    :  _ucKeyID : ID0ʼ
*	  ֵ: 1 ʾ£ 0 ʾδ
*********************************************************************************************************
*/
uint8_t bsp_GetKeyState(KEY_ID_E _ucKeyID)
{
	return s_tBtn[_ucKeyID].State;
}

/*
*********************************************************************************************************
*	  : bsp_SetKeyParam
*	˵: ð
*	    Σ_ucKeyID : ID0ʼ
*			_LongTime : ¼ʱ
*			 _RepeatSpeed : ٶ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_SetKeyParam(uint8_t _ucKeyID, uint16_t _LongTime, uint8_t  _RepeatSpeed)
{
	s_tBtn[_ucKeyID].LongTime = _LongTime;			/* ʱ 0 ʾⳤ¼ */
	s_tBtn[_ucKeyID].RepeatSpeed = _RepeatSpeed;			/* ٶȣ0ʾ֧ */
	s_tBtn[_ucKeyID].RepeatCount = 0;						/*  */
}

/*
*********************************************************************************************************
*	  : bsp_ClearKey
*	˵: հFIFO
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_ClearKey(void)
{
	s_tKey.Read = s_tKey.Write;
}

/*
*********************************************************************************************************
*	  : bsp_DetectKey
*	˵: һ״̬뱻Եĵá
*	    : IOid 0ʼ
*	  ֵ: 
*********************************************************************************************************
*/
static void bsp_DetectKey(uint8_t i)
{
	KEY_T *pBtn;

	pBtn = &s_tBtn[i];
	if (IsKeyDownFunc(i))
	{
		if (pBtn->Count < KEY_FILTER_TIME)
		{
			pBtn->Count = KEY_FILTER_TIME;
		}
		else if(pBtn->Count < 2 * KEY_FILTER_TIME)
		{
			pBtn->Count++;
		}
		else
		{
			if (pBtn->State == 0)
			{
				pBtn->State = 1;

				/* ͰťµϢ */
				//bsp_PutKey((uint8_t)(3 * i + 1));
                flag_key_short_press = 1;
			}

			if (pBtn->LongTime > 0)
			{
				if (pBtn->LongCount < pBtn->LongTime)
				{
					/* ͰťµϢ */
					if (++pBtn->LongCount == pBtn->LongTime)
					{
						/* ֵ밴FIFO */
						//bsp_PutKey((uint8_t)(3 * i + 3));
                        flag_key_long_press = 1;
					}
				}
				else
				{
					if (pBtn->RepeatSpeed > 0)
					{
						if (++pBtn->RepeatCount >= pBtn->RepeatSpeed)
						{
							pBtn->RepeatCount = 0;
							/* ÿ10ms1 */
							bsp_PutKey((uint8_t)(3 * i + 1));
						}
					}
				}
			}
		}
	}
	else
	{
		if(pBtn->Count > KEY_FILTER_TIME)
		{
			pBtn->Count = KEY_FILTER_TIME;
		}
		else if(pBtn->Count != 0)
		{
			pBtn->Count--;
		}
		else
		{
			if (pBtn->State == 1)
			{
				pBtn->State = 0;

				/* ͰťϢ */
//				bsp_PutKey((uint8_t)(3 * i + 2));
                if((flag_key_short_press == 1)&&(flag_key_long_press == 0)){
                    flag_key_short_press = 0;
                    bsp_PutKey((uint8_t)(3 * i + 1));
                }else if((flag_key_short_press == 1)&&(flag_key_long_press == 1)){
                    flag_key_short_press = 0;
                    flag_key_long_press = 0;
                    bsp_PutKey((uint8_t)(3 * i + 3));
                }
			}
		}

		pBtn->LongCount = 0;
		pBtn->RepeatCount = 0;
	}
}

/*
*********************************************************************************************************
*	  : bsp_DetectFastIO
*	˵: ٵIO. 1msˢһ
*	    : IOid 0ʼ
*	  ֵ: 
*********************************************************************************************************
*/
static void bsp_DetectFastIO(uint8_t i)
{
	KEY_T *pBtn;

	pBtn = &s_tBtn[i];
	if (IsKeyDownFunc(i))
	{
		if (pBtn->State == 0)
		{
			pBtn->State = 1;

			/* ͰťµϢ */
			bsp_PutKey((uint8_t)(3 * i + 1));
		}

		if (pBtn->LongTime > 0)
		{
			if (pBtn->LongCount < pBtn->LongTime)
			{
				/* ͰťµϢ */
				if (++pBtn->LongCount == pBtn->LongTime)
				{
					/* ֵ밴FIFO */
					bsp_PutKey((uint8_t)(3 * i + 3));
				}
			}
			else
			{
				if (pBtn->RepeatSpeed > 0)
				{
					if (++pBtn->RepeatCount >= pBtn->RepeatSpeed)
					{
						pBtn->RepeatCount = 0;
						/* ÿ10ms1 */
						bsp_PutKey((uint8_t)(3 * i + 1));
					}
				}
			}
		}
	}
	else
	{
		if (pBtn->State == 1)
		{
			pBtn->State = 0;

			/* ͰťϢ */
			bsp_PutKey((uint8_t)(3 * i + 2));
		}

		pBtn->LongCount = 0;
		pBtn->RepeatCount = 0;
	}
}

/*
*********************************************************************************************************
*	  : bsp_KeyScan10ms
*	˵: ɨаsystickжԵĵã10msһ
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_KeyScan10ms(void)
{
	uint8_t i;

	for (i = 0; i < KEY_COUNT; i++)
	{
		bsp_DetectKey(i);
	}
}

/*
*********************************************************************************************************
*	  : bsp_KeyScan1ms
*	˵: ɨаsystickжԵĵã1msһ.
*	    : 
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_KeyScan1ms(void)
{
	uint8_t i;

	for (i = 0; i < KEY_COUNT; i++)
	{
		bsp_DetectFastIO(i);
	}
}

/****** Copyright (C) 2025-2050 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved. *******/
