/**
  ******************************************************************************
  * ļ    bsp_timer.c
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/
#include "bsp.h"

/*
	ӲʱTIM ʹ TIM2 - TIM5
*/
#define USE_TIM2

/* 2ȫֱת bsp_DelayMS()  */
static volatile uint32_t s_uiDelayCount = 0;
static volatile uint8_t s_ucTimeOutFlag = 0;

/* ʱṹ */
static SOFT_TMR s_tTmr[TMR_COUNT] = {0};

/*
	ȫʱ䣬λ1ms
	Աʾ 24.85죬ĲƷʱ䳬뿼
*/
__IO int32_t g_iRunTime = 0;

static __IO uint8_t g_ucEnableSystickISR = 0;	/* ȴʼ */

static void bsp_SoftTimerDec(SOFT_TMR *_tmr);


/*
*********************************************************************************************************
*	  : bsp_InitTimer
*	˵: systickжϣʼʱ
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_InitTimer(void)
{
	uint8_t i;

	/* еʱ */
	for (i = 0; i < TMR_COUNT; i++)
	{
		s_tTmr[i].Count = 0;
		s_tTmr[i].PreLoad = 0;
		s_tTmr[i].Flag = 0;
		s_tTmr[i].Mode = TMR_ONCE_MODE;	/* ȱʡ1Թģʽ */
	}

	/*
		systicжΪ1mssystickжϡ

    	SystemCoreClock ǹ̼жϵͳںʱӣSTM32H7,һΪ400MHz

    	SysTick_Config() βαʾںʱӶٸں󴥷һSystickʱж.
	    	-- SystemCoreClock / 1000  ʾʱƵΪ 1000Hz ҲǶʱΪ  1ms
	    	-- SystemCoreClock / 500   ʾʱƵΪ 500Hz  ҲǶʱΪ  2ms
	    	-- SystemCoreClock / 2000  ʾʱƵΪ 2000Hz ҲǶʱΪ  500us

    	ڳӦãһȡʱ1msڵCPUߵ͹ӦãöʱΪ 10ms
    */
	SysTick_Config(SystemCoreClock / 1000);
	
	g_ucEnableSystickISR = 1;		/* 1ʾִsystickж */
	
	//bsp_InitHardTimer();
}

/*
*********************************************************************************************************
*	  : SysTick_ISR
*	˵: SysTickжϷÿ1ms1
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
void SysTick_ISR(void)
{
//	static uint8_t s_count = 0;
	uint8_t i;
	
	/* ÿ1ms1  bsp_DelayMS */
	if (s_uiDelayCount > 0)
	{
		if (--s_uiDelayCount == 0)
		{
			s_ucTimeOutFlag = 1;
		}
	}

	/* ÿ1msʱļмһ */
	for (i = 0; i < TMR_COUNT; i++)
	{
		bsp_SoftTimerDec(&s_tTmr[i]);
	}

	/* ȫʱÿ1ms1 */
	g_iRunTime++;
	if (g_iRunTime == 0x7FFFFFFF)	/*  int32_t ͣΪ 0x7FFFFFFF */
	{
		g_iRunTime = 0;
	}

//	bsp_RunPer1ms();		/* ÿ1msһδ˺˺ bsp.c */

//	if (++s_count >= 10)
//	{
//		s_count = 0;

//		bsp_RunPer10ms();	/* ÿ10msһδ˺˺ bsp.c */
//	}
}

/*
*********************************************************************************************************
*	  : bsp_SoftTimerDec
*	˵: ÿ1msжʱ1뱻SysTick_ISRԵá
*	    :  _tmr : ʱָ
*	  ֵ: 
*********************************************************************************************************
*/
static void bsp_SoftTimerDec(SOFT_TMR *_tmr)
{
	if (_tmr->Count > 0)
	{
		/* ʱ1öʱ־ */
		if (--_tmr->Count == 0)
		{
			_tmr->Flag = 1;

			/* ԶģʽԶװ */
			if(_tmr->Mode == TMR_AUTO_MODE)
			{
				_tmr->Count = _tmr->PreLoad;
			}
		}
	}
}

/*
*********************************************************************************************************
*	  : bsp_DelayMS
*	˵: msӳ٣ӳپΪ1ms
*	    :  n : ӳٳȣλ1 ms n Ӧ2
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_DelayMS(uint32_t n)
{
	if (n == 0)
	{
		return;
	}
	else if (n == 1)
	{
		n = 2;
	}

	DISABLE_INT();  			/* ж */

	s_uiDelayCount = n;
	s_ucTimeOutFlag = 0;

	ENABLE_INT();  				/* ж */

	while (1)
	{
		bsp_Idle();				/* CPUִеĲ  bsp.c  bsp.h ļ */

		/*
			ȴӳʱ䵽
			ע⣺Ϊ s_ucTimeOutFlag = 0ԿŻ s_ucTimeOutFlag Ϊ volatile
		*/
		if (s_ucTimeOutFlag == 1)
		{
			break;
		}
	}
}

/*
*********************************************************************************************************
*      : bsp_DelayUS
*    ˵: usӳ١ systickʱܵô˺
*        :  n : ӳٳȣλ1 us
*      ֵ: 
*********************************************************************************************************
*/
void bsp_DelayUS(uint32_t n)
{
    uint32_t ticks;
    uint32_t told;
    uint32_t tnow;
    uint32_t tcnt = 0;
    uint32_t reload;
       
	reload = SysTick->LOAD;                
    ticks = n * (SystemCoreClock / 1000000);	 /* ҪĽ */  
    
    tcnt = 0;
    told = SysTick->VAL;             /* սʱļֵ */

    while (1)
    {
        tnow = SysTick->VAL;    
        if (tnow != told)
        {    
            /* SYSTICKһݼļ */    
            if (tnow < told)
            {
                tcnt += told - tnow;    
            }
            /* װصݼ */
            else
            {
                tcnt += reload - tnow + told;    
            }        
            told = tnow;

            /* ʱ䳬/Ҫӳٵʱ,˳ */
            if (tcnt >= ticks)
            {
            	break;
            }
        }  
    }
} 

/*
*********************************************************************************************************
*	  : bsp_StartTimer
*	˵: һʱöʱڡ
*	    :  	_id     : ʱIDֵ0,TMR_COUNT-1ûάʱIDԱⶨʱIDͻ
*				_period : ʱڣλ1ms
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_StartTimer(uint8_t _id, uint32_t _period)
{
	if (_id >= TMR_COUNT)
	{
		/* ӡԴļ */
		BSP_Printf("Error: file %s, function %s()\r\n", __FILE__, __FUNCTION__);
		while(1); /* 쳣ȴŹλ */
	}

	DISABLE_INT();  			/* ж */

	s_tTmr[_id].Count = _period;		/* ʵʱֵ */
	s_tTmr[_id].PreLoad = _period;		/* ԶװֵԶģʽ */
	s_tTmr[_id].Flag = 0;				/* ʱʱ䵽־ */
	s_tTmr[_id].Mode = TMR_ONCE_MODE;	/* 1Թģʽ */

	ENABLE_INT();  				/* ж */
}

/*
*********************************************************************************************************
*	  : bsp_StartAutoTimer
*	˵: һԶʱöʱڡ
*	    :  	_id     : ʱIDֵ0,TMR_COUNT-1ûάʱIDԱⶨʱIDͻ
*				_period : ʱڣλ10ms
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_StartAutoTimer(uint8_t _id, uint32_t _period)
{
	if (_id >= TMR_COUNT)
	{
		/* ӡԴļ */
		BSP_Printf("Error: file %s, function %s()\r\n", __FILE__, __FUNCTION__);
		while(1); /* 쳣ȴŹλ */
	}

	DISABLE_INT();  		/* ж */

	s_tTmr[_id].Count = _period;			/* ʵʱֵ */
	s_tTmr[_id].PreLoad = _period;		/* ԶװֵԶģʽ */
	s_tTmr[_id].Flag = 0;				/* ʱʱ䵽־ */
	s_tTmr[_id].Mode = TMR_AUTO_MODE;	/* Զģʽ */

	ENABLE_INT();  			/* ж */
}

/*
*********************************************************************************************************
*	  : bsp_StopTimer
*	˵: ֹͣһʱ
*	    :  	_id     : ʱIDֵ0,TMR_COUNT-1ûάʱIDԱⶨʱIDͻ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_StopTimer(uint8_t _id)
{
	if (_id >= TMR_COUNT)
	{
		/* ӡԴļ */
		BSP_Printf("Error: file %s, function %s()\r\n", __FILE__, __FUNCTION__);
		while(1); /* 쳣ȴŹλ */
	}

	DISABLE_INT();  	/* ж */

	s_tTmr[_id].Count = 0;				/* ʵʱֵ */
	s_tTmr[_id].Flag = 0;				/* ʱʱ䵽־ */
	s_tTmr[_id].Mode = TMR_ONCE_MODE;	/* Զģʽ */

	ENABLE_INT();  		/* ж */
}

/*
*********************************************************************************************************
*	  : bsp_CheckTimer
*	˵: ⶨʱǷʱ
*	    :  	_id     : ʱIDֵ0,TMR_COUNT-1ûάʱIDԱⶨʱIDͻ
*				_period : ʱڣλ1ms
*	  ֵ:  0 ʾʱδ 1ʾʱ
*********************************************************************************************************
*/
uint8_t bsp_CheckTimer(uint8_t _id)
{
	if (_id >= TMR_COUNT)
	{
		return 0;
	}

	if (s_tTmr[_id].Flag == 1)
	{
		s_tTmr[_id].Flag = 0;
		return 1;
	}
	else
	{
		return 0;
	}
}

/*
*********************************************************************************************************
*	  : bsp_GetRunTime
*	˵: ȡCPUʱ䣬λ1msԱʾ 24.85죬ĲƷʱ䳬뿼
*	    :  
*	  ֵ: CPUʱ䣬λ1ms
*********************************************************************************************************
*/
int32_t bsp_GetRunTime(void)
{
	int32_t runtime;

	DISABLE_INT();  	/* ж */

	runtime = g_iRunTime;	/* SystickжбдҪжϽб */

	ENABLE_INT();  		/* ж */

	return runtime;
}

/*
*********************************************************************************************************
*	  : bsp_CheckRunTime
*	˵: 㵱ǰʱ͸ʱ֮Ĳֵ˼ѭ
*	    :  _LastTime ϸʱ
*	  ֵ: ǰʱ͹ȥʱĲֵλ1ms
*********************************************************************************************************
*/
int32_t bsp_CheckRunTime(int32_t _LastTime)
{
	int32_t now_time;
	int32_t time_diff;

	DISABLE_INT();  	/* ж */

	now_time = g_iRunTime;	/* SystickжбдҪжϽб */

	ENABLE_INT();  		/* ж */
	
	if (now_time >= _LastTime)
	{
		time_diff = now_time - _LastTime;
	}
	else
	{
		time_diff = 0x7FFFFFFF - _LastTime + now_time;
	}

	return time_diff;
}

/*
*********************************************************************************************************
*	  : SysTick_Handler
*	˵: ϵͳશʱжϷļ˸ú
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
void SysTick_Handler(void)
{
	HAL_IncTick();	/* ST HALĵδʱжϷ */
	
	if (g_ucEnableSystickISR == 0)
	{
		return;
	}
	
	SysTick_ISR();	/* bspĵδʱжϷ */
}

/*
*********************************************************************************************************
*	ĴʹһTIM4жϣʵ4Ӳʱ
*********************************************************************************************************
*/

#ifdef TIM_HARD


#endif

/****** Copyright (C) 2025-2050 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved. *******/
