/**
  ******************************************************************************
  * ļ    bsp_timer.h
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/

#ifndef __BSP_TIMER_H
#define __BSP_TIMER_H

/*
	ڴ˶ɸʱȫֱ
	ע⣬__IO  volatileΪжϺͬʱʣпɱŻ
*/
#define TMR_COUNT	4		/* ʱĸ ʱIDΧ 0 - 3) */

/* ʱṹ壬Ա volatile, CŻʱ */
typedef enum
{
	TMR_ONCE_MODE = 0,		/* һιģʽ */
	TMR_AUTO_MODE = 1		/* Զʱģʽ */
}TMR_MODE_E;

/* ʱṹ壬Ա volatile, CŻʱ */
typedef struct
{
	volatile uint8_t Mode;		/* ģʽ1 */
	volatile uint8_t Flag;		/* ʱ־  */
	volatile uint32_t Count;	/*  */
	volatile uint32_t PreLoad;	/* Ԥװֵ */
}SOFT_TMR;

/* ṩCļõĺ */
void bsp_InitTimer(void);
void bsp_DelayMS(uint32_t n);
void bsp_DelayUS(uint32_t n);
void bsp_StartTimer(uint8_t _id, uint32_t _period);
void bsp_StartAutoTimer(uint8_t _id, uint32_t _period);
void bsp_StopTimer(uint8_t _id);
uint8_t bsp_CheckTimer(uint8_t _id);
int32_t bsp_GetRunTime(void);
int32_t bsp_CheckRunTime(int32_t _LastTime);

void SysTick_Handler(void);
#endif

/****** Copyright (C) 2025-2050 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved. *******/
