/**
  ******************************************************************************
  * ļ    bsp_led.h
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/
#include "bsp.h"

/*
        LED߷䣺
		GREEN    : PA8    (ߵƽ͵ƽϨ)
		BLUE     : PB15   (ߵƽ͵ƽϨ)
*/

/* LEDڶӦRCCʱ */
#define LED_GPIO_CLK_ALLENABLE() {	    \
		__HAL_RCC_GPIOA_CLK_ENABLE();	\
		__HAL_RCC_GPIOB_CLK_ENABLE(); \
	};

#define GPIO_PORT_LED1  GPIOA
#define GPIO_PIN_LED1	GPIO_PIN_11
   

#define GPIO_PORT_LED2  GPIOA
#define GPIO_PIN_LED2	GPIO_PIN_12

#define GPIO_PORT_LED3  GPIOA
#define GPIO_PIN_LED3	GPIO_PIN_8

// LEDŶ
#define GREEN_LED_GPIO_PORT 	GPIOA
#define GREEN_LED_GPIO_PIN 		GPIO_PIN_8
	
#define BLUE_LED_GPIO_PORT 		GPIOB
#define BLUE_LED_GPIO_PIN 		GPIO_PIN_15


/*
*********************************************************************************************************
*	  : bsp_InitLed
*	˵: LEDָʾصGPIO,  ú bsp_Init() á
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_InitLed(void)
{
	GPIO_InitTypeDef  GPIO_InitStruct;

	/* GPIOʱ */
	LED_GPIO_CLK_ALLENABLE();
	
	/*
		еLEDָʾGPIOΪģʽ
		ڽGPIOΪʱGPIOĴֵȱʡ0˻LED.
		ҲϣģڸıGPIOΪǰȹرLEDָʾ
	*/
	bsp_LedOff(GREEN_LED);
	bsp_LedOff(BLUE_LED);

	// Green LED (PA8)
	GPIO_InitStruct.Pin = GREEN_LED_GPIO_PIN;
	GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
	GPIO_InitStruct.Pull = GPIO_NOPULL;
	GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
	HAL_GPIO_Init(GREEN_LED_GPIO_PORT, &GPIO_InitStruct);
	
	// Blue LED (PB15)
	GPIO_InitStruct.Pin = BLUE_LED_GPIO_PIN;
	HAL_GPIO_Init(BLUE_LED_GPIO_PORT, &GPIO_InitStruct);
	
}

// Green LED
void Green_LED_On(void)
{
    HAL_GPIO_WritePin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN, GPIO_PIN_SET);
}

// رGreen LED
void Green_LED_Off(void)
{
    HAL_GPIO_WritePin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN, GPIO_PIN_RESET);
}

// лGreen LED״̬
void Green_LED_Toggle(void)
{
    HAL_GPIO_TogglePin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN);
}

// Blue LED
void Blue_LED_On(void)
{
    HAL_GPIO_WritePin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN, GPIO_PIN_SET);
}

// رBlue LED
void Blue_LED_Off(void)
{
    HAL_GPIO_WritePin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN, GPIO_PIN_RESET);
}

// лBlue LED״̬
void Blue_LED_Toggle(void)
{
    HAL_GPIO_TogglePin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN);
}

/*
*********************************************************************************************************
*	  : bsp_LedOn
*	˵: ָLEDָʾơ
*	    :  _no : ָʾ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_LedOn(uint8_t _no)
{
	if (_no == GREEN_LED)
	{
		HAL_GPIO_WritePin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN, GPIO_PIN_SET);
	}
	else if (_no == BLUE_LED)
	{
		HAL_GPIO_WritePin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN, GPIO_PIN_SET);
	}
}

/*
*********************************************************************************************************
*	  : bsp_LedOff
*	˵: ϨָLEDָʾơ
*	    :  _no : ָʾ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_LedOff(uint8_t _no)
{
	if (_no == GREEN_LED)
	{
		HAL_GPIO_WritePin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN, GPIO_PIN_RESET);
	}
	else if (_no == BLUE_LED)
	{
		HAL_GPIO_WritePin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN, GPIO_PIN_RESET);
	}
}

/*
*********************************************************************************************************
*	  : bsp_LedToggle
*	˵: תָLEDָʾơ
*	    :  _no : ָʾ
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_LedToggle(uint8_t _no)
{
	if (_no == GREEN_LED)
	{
		HAL_GPIO_TogglePin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN);
	}
	else if (_no == BLUE_LED)
	{
		HAL_GPIO_TogglePin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN);
	}
}

/*
*********************************************************************************************************
*	  : bsp_IsLedOn
*	˵: жLEDָʾǷѾ
*	    :  _no : ָʾ
*	  ֵ: 1ʾѾ0ʾδ
*********************************************************************************************************
*/
uint8_t bsp_IsLedOn(uint8_t _no)
{
	if (_no == GREEN_LED)
	{
		if (HAL_GPIO_ReadPin(GREEN_LED_GPIO_PORT, GREEN_LED_GPIO_PIN) == GPIO_PIN_SET)
		{
			return GPIO_PIN_SET;
		}
		return GPIO_PIN_RESET;
	}
	else if (_no == BLUE_LED)
	{
		if (HAL_GPIO_ReadPin(BLUE_LED_GPIO_PORT, BLUE_LED_GPIO_PIN) == GPIO_PIN_SET)
		{
			return GPIO_PIN_SET;
		}
		return GPIO_PIN_RESET;
	}

	return 0;
}
/****** Copyright (C) 2025-2050 Shanghai Panchip Microelectronics Co., Ltd. All rights reserved. *******/
