/**
  ******************************************************************************
  * ļ    bsp_uart.c
  *       PAN312x RF Team
  * 汾      V1.0.0
  * ʱ      
  * ļ

*******************************************************************************/
#include "bsp.h"




// ʼ
void bsp_InitQueue(CircularQueue *q) {
    q->head = 0;
    q->tail = 0;
}

// ж϶ǷΪ
bool bsp_QueueIsEmpty(CircularQueue *q) {
    return (q->head == q->tail);
}

// ж϶Ƿ
bool bsp_QueueIsFull(CircularQueue *q) {
    return ((q->head + 1) & (QUEUE_SIZE-1)) == q->tail;
}

// ӣʣռ䣩
int bsp_QueuePush(CircularQueue *q, uint8_t data) {
    if(bsp_QueueIsFull(q)) return -1; // 
    
    q->buffer[q->head] = data;
    q->head = (q->head + 1) & (QUEUE_SIZE-1); // λȡģ
    return QUEUE_SIZE - ((q->head - q->tail) & (QUEUE_SIZE-1)) -1;
}

// ݳ
uint8_t bsp_QueuePop(CircularQueue *q) {
    uint8_t data = 0;
    if(!bsp_QueueIsEmpty(q)){
        data = q->buffer[q->tail];
        q->tail = (q->tail + 1) & (QUEUE_SIZE-1);
    }
    return data;
}

// ȡԪ
uint16_t bsp_QueueCount(CircularQueue *q) {
    return (q->head - q->tail) & (QUEUE_SIZE-1);
}
