/***************************************************************************************************
 * This file is generated by PANCHIP RF CTK
 * @datetime 2025-08-01 15:11:39
 * @device   PAN3120
 * @fwid     0x0003
 * @version  0x0000
 ***************************************************************************************************
 * Frequency Band(MHz)       : 420 <= frequency < 440
 * Frequency Base(MHz)       : 433.0
 * Frequency Step(MHz)       : 0.0
 * Frequency Channel         : 0
 * Data Rate Mode            : Symbol Rate B
 * Modulation                : 2FSK
 * Tx Power(dBm)             : 20
 * IE of Tx Done             : true
 * Power Supply Mode         : LDO
 * Inductor Package          : SMD0603
 * IE of Rx Done             : true
 * IE of Rx Complete         : false
 * IE of CRC Error           : true
 * IE of Rx Timeout          : false
 * IE of Node ID Error       : false
 * IE of Length Done         : false
 * IE of Node ID Done        : false
 * IE of Header CRC Done     : false
 * IE of Wakeup              : false
 * IE of Ack Timeout         : false
 * IE of Ack Error           : false
 * IE of Syncword Timeout    : false
 * IE of Tx FIFO Threshold   : false
 * IE of Rx FIFO Threshold   : false
 * IE of RSSI Valid          : false
 * IE of Preamble Done       : false
 * IE of Syncword Done       : false
 * IE of Preamble Timeout    : false
 * IE of RSSI Timeout        : false
 * WUT Clock Divider         : 65536
 * RCL Trim Timer            : Off
 * Auto Clear Status         : true
 * Idle If Possible          : false
 * Duty Cycle Period         : 0
 * Sleep Timer               : Off
 * Tx Extra Times            : 0
 * Rx Timeout(us)            : 0
 * Ack Delay Time(us)        : 0
 * Ack Timeout(us)           : 0
 * Ack Check                 : Off
 * Ack Tx Byte               : 0x00
 * Exit State of Tx Ok       : Ready
 * Exit State of Ack Timeout : Ready
 * Exit State of Ack Error   : Ready
 * Exit State of Rx Valid    : Rx
 * Exit State of Rx Invalid  : Rx
 * Exit State of Rx Timeout  : Rx
 * Direct Enable             : false
 * Packet Type               : Variable Length
 * Node ID Size              : 4-bytes
 * CRC Mode                  : CRC-16
 * Payload Bit Order         : MSB First
 * Payload Manchester        : Disable
 * Whitening                 : Disable
 * Encoding                  : None
 * Preamble Mode             : Standard-0101
 * Preamble Tx Size          : 4
 * Preamble Manchester       : Disable
 * Syncword Size             : 4-bytes
 * Syncword Value            : 0x2dd42dd4
 * Syncword Manchester       : Disable
 * Node ID Position          : Before Length
 * Tx Node ID Value          : 0xaabbccdd
 * Packet Filter Mode        : Reset
 * Packet Filter Interrupt   : false
 * Packet Filter Mask        : 0x00
 * Packet Filter Pat1 Enable : true
 * Packet Filter Pat1 Value  : 0xa0b0c0d0
 * Packet Filter Pat2 Enable : true
 * Packet Filter Pat2 Value  : 0xa1b1c1d1
 * Packet Filter Pat3 Enable : true
 * Packet Filter Pat3 Value  : 0xaabbccdd
 * Length Size               : 1-byte
 * Data Length               : 20
 * CRC Seed                  : 0xffff
 * CRC Poly                  : 0x8005
 * CRC Range                 : Include Node ID and Length
 * CRC Bit Invert            : false
 * CRC Byte Order            : Big Endian
 * CRC Bit Order             : MSB First
 * TX_DEVIATION              : 25000
 * RX_DEVIATION              : 25000
 * DATA_RATE                 : 50
 **************************************************************************************************/
#ifndef PAN312X_RF_CTK_SETTING_H
#define PAN312X_RF_CTK_SETTING_H

#include <stdint.h>

#define __ctk_item_t(N)     \
    struct{                 \
        uint16_t addr;      \
        uint8_t  size;      \
        uint8_t  data[N];   \
    }
typedef __ctk_item_t(1)   ctk_item_t;

#define INDUCTOR_PACKAGE_SMD0603    0x0603
#define INDUCTOR_PACKAGE_SMD0402    0x0402

#define POWER_SUPPLY_MODE_LDO       0
#define POWER_SUPPLY_MODE_DCDC      1

#define                         __CTK_ITEM_COUNT  25
extern ctk_item_t const * const __CTK_ITEM_ARRAY[__CTK_ITEM_COUNT + 1];

/*******************************************************************************
 * frequency configuration
 ******************************************************************************/
#define CTK_DEF_FREQUENCY_BASE     433.0
#define CTK_DEF_FREQUENCY_STEP     0.0
#define CTK_DEF_FREQUENCY_CHANNEL  0
#define CTK_DEF_FREQUENCY          (CTK_DEF_FREQUENCY_BASE + CTK_DEF_FREQUENCY_STEP * CTK_DEF_FREQUENCY_CHANNEL)

/*******************************************************************************
 * data rate configuration
 ******************************************************************************/
#define CTK_DEF_DATA_RATE_KHZ      50
#define CTK_DEF_TX_DEVIATION       25000
#define CTK_DEF_RX_DEVIATION       25000

/*******************************************************************************
 * power configuration
 ******************************************************************************/
#define CTK_DEF_POWER_SUPPLY_MODE  POWER_SUPPLY_MODE_LDO
#define CTK_DEF_INDUCTOR_PACKAGE   INDUCTOR_PACKAGE_SMD0603
#define CTK_DEF_TX_POWER           20

/*******************************************************************************
 * predefined for configuration define
 ******************************************************************************/
#define CTK_BIT_ORDER_LSB_FIRST                  2
#define CTK_BIT_ORDER_MSB_FIRST                  1
#define CTK_BYTE_ORDER_BIG_ENDIAN                1
#define CTK_BYTE_ORDER_LITTLE_ENDIAN             2
#define CTK_CRC_RANGE_DATA_ONLY                  1
#define CTK_CRC_RANGE_INCLUDE_NODE_ID_AND_LENGTH 3
#define CTK_DIRECT_DAT_GPIO0_AS_RX               32
#define CTK_DIRECT_DAT_GPIO0_AS_TX               16
#define CTK_DIRECT_DAT_GPIO1_AS_RX               33
#define CTK_DIRECT_DAT_GPIO1_AS_TX               17
#define CTK_DIRECT_DAT_GPIO2_AS_RX               34
#define CTK_DIRECT_DAT_GPIO2_AS_TX               18
#define CTK_DIRECT_DAT_GPIO3_AS_RX               35
#define CTK_DIRECT_DAT_GPIO3_AS_TX               19
#define CTK_DIRECT_MODE_ASYNC                    1
#define CTK_DIRECT_MODE_SYNC                     2
#define CTK_ENCODING_HAMMING_X3_X2_1             2
#define CTK_ENCODING_HAMMING_X3_X_1              1
#define CTK_EXIT_STATE_READY                     1
#define CTK_EXIT_STATE_RX                        3
#define CTK_EXIT_STATE_SLEEP                     4
#define CTK_EXIT_STATE_TX                        2
#define CTK_MANCHESTER_1_TO_01                   1
#define CTK_MANCHESTER_1_TO_10                   2
#define CTK_MODULATION_2FSK                      1
#define CTK_MODULATION_2GFSK                     2
#define CTK_MODULATION_GMSK                      4
#define CTK_MODULATION_MSK                       3
#define CTK_NODE_ID_POSITION_AFTER_LENGTH        2
#define CTK_NODE_ID_POSITION_BEFORE_LENGTH       1
#define CTK_PACKET_FILTER_MODE_KEEP              1
#define CTK_PACKET_FILTER_MODE_RESET             2
#define CTK_PACKET_TYPE_FIXED_LENGTH             1
#define CTK_PACKET_TYPE_VARIABLE_LENGTH          2
#define CTK_PREAMBLE_MODE_NON_STANDARD           1
#define CTK_PREAMBLE_MODE_STANDARD_0101          2
#define CTK_PREAMBLE_MODE_STANDARD_1010          3
#define CTK_SYMBOL_RATE_A                        1
#define CTK_SYMBOL_RATE_B                        2
#define CTK_WHITENING_IEEE_802_15_4G             10
#define CTK_WHITENING_PN11                       11
#define CTK_WHITENING_PN13                       13
#define CTK_WHITENING_PN15                       15
#define CTK_WHITENING_PN6                        6
#define CTK_WHITENING_PN7                        7
#define CTK_WHITENING_PN9                        9
#define CTK_WHITENING_PN9_CCITT                  41
#define CTK_WHITENING_PN9_IBM                    25

/*******************************************************************************
 * user configuration define
 ******************************************************************************/
#define CTK_CONF_FREQUENCY_BAND             "420 <= frequency < 440"
#define CTK_CONF_FREQUENCY_BASE             433.0
#define CTK_CONF_FREQUENCY_STEP             0.0
#define CTK_CONF_FREQUENCY_CHANNEL          0
#define CTK_CONF_DATA_RATE_MODE             CTK_SYMBOL_RATE_B
#define CTK_CONF_MODULATION                 CTK_MODULATION_2FSK
#define CTK_CONF_TX_POWER                   20
#define CTK_CONF_IE_TX_DONE                 1
#define CTK_CONF_POWER_SUPPLY_MODE          "LDO"
#define CTK_CONF_INDUCTOR_PACKAGE           "SMD0603"
#define CTK_CONF_IE_RX_DONE                 1
#define CTK_CONF_IE_RX_COMPLETE             0
#define CTK_CONF_IE_CRC_ERROR               1
#define CTK_CONF_IE_RX_TIMEOUT              0
#define CTK_CONF_IE_NODE_ID_ERROR           0
#define CTK_CONF_IE_LENGTH_DONE             0
#define CTK_CONF_IE_NODE_ID_DONE            0
#define CTK_CONF_IE_HEADER_CRC_DONE         0
#define CTK_CONF_IE_WAKEUP                  0
#define CTK_CONF_IE_ACK_TIMEOUT             0
#define CTK_CONF_IE_ACK_ERROR               0
#define CTK_CONF_IE_SYNCWORD_TIMEOUT        0
#define CTK_CONF_IE_TX_FIFO_TH              0
#define CTK_CONF_IE_RX_FIFO_TH              0
#define CTK_CONF_IE_RSSI_VALID              0
#define CTK_CONF_IE_PREAMBLE_DONE           0
#define CTK_CONF_IE_SYNCWORD_DONE           0
#define CTK_CONF_IE_PREAMBLE_TIMEOUT        0
#define CTK_CONF_IE_RSSI_TIMEOUT            0
#define CTK_CONF_WUT_DIV                    65536
#define CTK_CONF_RCLTRIM_TIMER_EN           0
#define CTK_CONF_AUTO_CLEAR_STATUS          1
#define CTK_CONF_IDLE_IF_POSSIBLE           0
#define CTK_CONF_DUTY_CYCLE_PERIOD          0
#define CTK_CONF_SLEEP_TIMER_EN             0
#define CTK_CONF_TX_EXTRA_TIMES             0
#define CTK_CONF_RX_TIMEOUT                 0
#define CTK_CONF_ACK_DELAY_TIME             0
#define CTK_CONF_ACK_TIMEOUT                0
#define CTK_CONF_ACK_CHECK_EN               0
#define CTK_CONF_ACK_TX_BYTE                0x00
#define CTK_CONF_TX_OK_EXIT_STATE           CTK_EXIT_STATE_READY
#define CTK_CONF_ACK_TIMEOUT_EXIT_STATE     CTK_EXIT_STATE_READY
#define CTK_CONF_ACK_ERROR_EXIT_STATE       CTK_EXIT_STATE_READY
#define CTK_CONF_RX_VALID_EXIT_STATE        CTK_EXIT_STATE_RX
#define CTK_CONF_RX_INVALID_EXIT_STATE      CTK_EXIT_STATE_RX
#define CTK_CONF_RX_TIMEOUT_EXIT_STATE      CTK_EXIT_STATE_RX
#define CTK_CONF_DIRECT_ENABLE              0
#define CTK_CONF_PACKET_TYPE                CTK_PACKET_TYPE_VARIABLE_LENGTH
#define CTK_CONF_NODE_ID_SIZE               4
#define CTK_CONF_CRC_MODE                   16
#define CTK_CONF_PAYLOAD_BIT_ORDER          CTK_BIT_ORDER_MSB_FIRST
#define CTK_CONF_PAYLOAD_MANCHESTER         0
#define CTK_CONF_WHITENING                  0
#define CTK_CONF_ENCODING                   0
#define CTK_CONF_PREAMBLE_MODE              CTK_PREAMBLE_MODE_STANDARD_0101
#define CTK_CONF_PREAMBLE_TX_SIZE           4
#define CTK_CONF_PREAMBLE_MANCHESTER        0
#define CTK_CONF_SYNCWORD_SIZE              4
#define CTK_CONF_SYNCWORD_VALUE             0x2dd42dd4
#define CTK_CONF_SYNCWORD_MANCHESTER        0
#define CTK_CONF_NODE_ID_POSITION           CTK_NODE_ID_POSITION_BEFORE_LENGTH
#define CTK_CONF_TX_NODE_ID_VALUE           0xaabbccdd
#define CTK_CONF_PACKET_FILTER_MODE         CTK_PACKET_FILTER_MODE_RESET
#define CTK_CONF_PACKET_FILTER_INTERRUPT_EN 0
#define CTK_CONF_PACKET_FILTER_MASK         0x00
#define CTK_CONF_PACKET_FILTER_PAT1_ENABLE  1
#define CTK_CONF_PACKET_FILTER_PAT1_VALUE   0xa0b0c0d0
#define CTK_CONF_PACKET_FILTER_PAT2_ENABLE  1
#define CTK_CONF_PACKET_FILTER_PAT2_VALUE   0xa1b1c1d1
#define CTK_CONF_PACKET_FILTER_PAT3_ENABLE  1
#define CTK_CONF_PACKET_FILTER_PAT3_VALUE   0xaabbccdd
#define CTK_CONF_LENGTH_SIZE                1
#define CTK_CONF_DATA_LENGTH                20
#define CTK_CONF_CRC_SEED                   0xffff
#define CTK_CONF_CRC_POLY                   0x8005
#define CTK_CONF_CRC_RANGE                  CTK_CRC_RANGE_INCLUDE_NODE_ID_AND_LENGTH
#define CTK_CONF_CRC_BIT_INVERT             0
#define CTK_CONF_CRC_BYTE_ORDER             CTK_BYTE_ORDER_BIG_ENDIAN
#define CTK_CONF_CRC_BIT_ORDER              CTK_BIT_ORDER_MSB_FIRST
#define CTK_CONF_TX_DEVIATION               25000
#define CTK_CONF_RX_DEVIATION               25000
#define CTK_CONF_DATA_RATE                  50

#endif //PAN312X_RF_CTK_SETTING_H
