#ifndef __UART_FIFO_H__
#define __UART_FIFO_H__

#include <stdio.h>
#include <stdbool.h>
#include "stdint.h"

#define RINGBUFF_OK 0     /* No error, everything OK. */
#define RINGBUFF_ERR -1   /* Out of memory error.     */
#define RINGBUFF_EMPTY -3 /* Timeout.                 */
#define RINGBUFF_FULL -4  /* Routing problem.          */
#define RINGBUFF_TOO_SHORT -5
#define dataMaxLen 2048

typedef struct ring_buff_
{
    unsigned int size;
    unsigned int readpoint;
    unsigned int writepoint;
    char *buffer;
		uint8_t data[dataMaxLen];
		uint8_t datalen;
    bool full;
	bool finishFlag;
} ring_buff_t;

int ring_buff_init(char* buff, unsigned int size);
int ring_buff_flush(void);
int ring_buff_push_data(char *pData, int len);
int ring_buff_pop_data(char *pData, int len);
unsigned int ring_buff_get_size(void);

extern ring_buff_t ring_buff;
#endif // __ringbuff_h__
