#include "stm32f10x.h"
#include <stdio.h>
#include <string.h>
#include "UART_FIFO.h"
#include "HAL_uart.h"
#include "sx127x_cmd_process.h"

#define dataMaxLen 2048
/*��δ���������֧��printf��ӡ�����ڵĴ���*/
#pragma import(__use_no_semihosting)
// ��׼����Ҫ֧�ֵĺ���
struct __FILE
{
	int handle;
};

FILE __stdout;
// ����_sys_exit()�Ա��⹤���ڰ�����״̬
void _sys_exit(int x)
{
	x = x;
}

typedef struct
{
	uint8_t data[dataMaxLen];
	uint8_t datalen;
} Uart_Buffer_t;
Uart_Buffer_t _uart_buf = {0};

int fputc(int ch, FILE *f)
{
	while (USART_GetFlagStatus(USART1, USART_FLAG_TXE) == RESET)
	{
	}
	USART_SendData(USART1, (uint8_t)ch);
	// while (USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET)
	//{}

	return ch;
}

// USART1 IRQ Handler func
void USART1_IRQHandler(void)
{
	if (USART_GetFlagStatus(USART1, USART_FLAG_RXNE) == SET)
	{
		//		USART_SendData(USART1, USART_ReceiveData(USART1));
		USART_ClearFlag(USART1, USART_FLAG_RXNE);
	}
}

// uart1(PA_9 TX,PA_10 RX) init func
uint8_t HALUart1Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	USART_InitTypeDef USART_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;

	USART_DeInit(USART1);														  // deint before init
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA, ENABLE); // enable APB1 clock for PB2
	// PA_9 GPIO INIT
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz; // IO run at 50MHz speed
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP; // set AF_PP mode
	GPIO_Init(GPIOA, &GPIO_InitStructure);			// init GPIO
	// PA_10 GPIO INIT
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU; // set pull-up mode
	GPIO_Init(GPIOA, &GPIO_InitStructure);		  // init GPIO

	// init interrupt func (NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2))
	NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn; // Interrupt Channel at USART1
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 3;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 2;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);

	// USART1 Init
	USART_InitStructure.USART_BaudRate = 115200;									// set baudrate
	USART_InitStructure.USART_WordLength = USART_WordLength_8b;						// set 8 bits databits
	USART_InitStructure.USART_StopBits = USART_StopBits_1;							// set 1 bits stopbit
	USART_InitStructure.USART_Parity = USART_Parity_No;								// don't need parity
	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None; // do not need HardwareFlowControl
	USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;					//
	USART_Init(USART1, &USART_InitStructure);										// init UART config
	USART_ITConfig(USART1, USART_IT_RXNE, ENABLE);									//
	USART_Cmd(USART1, ENABLE);														// enable UART1

	return 0;
}

// USART2 interrupt
void USART2_IRQHandler(void)
{
	u8 ucCh;
	if (USART_GetITStatus(USART2, USART_IT_RXNE) != RESET)
	{
		ucCh = USART_ReceiveData(USART2);
		if (TB05_Fram_Record_Struct.InfBit.FramLength < (RX_BUF_MAX_LEN - 1))
		{
			if (ucCh != 0)
			{
				TB05_Fram_Record_Struct.Data_RX_BUF[TB05_Fram_Record_Struct.InfBit.FramLength++] = ucCh;
			}
		}
		//		USART_SendData(USART1, TB05_Fram_Record_Struct .Data_RX_BUF[ TB05_Fram_Record_Struct .InfBit .FramLength-1]);
	}

	if (USART_GetITStatus(USART2, USART_IT_IDLE) == SET)
	{
		TB05_Fram_Record_Struct.InfBit.FramFinishFlag = 1;
		//				ring_buff.finishFlag = 1;
		ucCh = USART_ReceiveData(USART2);
		//				USART_SendData(USART1, ucCh);
		USART_ClearFlag(USART2, USART_FLAG_IDLE);
	}
}

uint8_t uart_receive_data(uint8_t *buffer)
{
	uint8_t bufferLen = _uart_buf.datalen;
	memcpy(buffer, _uart_buf.data, _uart_buf.datalen);
	_uart_buf.datalen = 0;
	return bufferLen;
}

// uart1(PA_2 TX,PA_3 RX)��ʼ������
uint8_t HALUart2Init(void)
{

	GPIO_InitTypeDef GPIO_InitStructure;
	USART_InitTypeDef USART_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;

	// RCC_APB2PeriphClockCmd(RCC_APB1Periph_USART1 | RCC_APB2Periph_GPIOA, ENABLE);  //ʹ��USART1ʱ��

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);  // ʹ��GPIOAʱ��
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2, ENABLE); // ʹ��USART2

	/*********************GPIO Config***************************/
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2;		// ���͹ܽ�
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP; // ��������
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_3;			  // ���չܽ�
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING; // ��������
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	//	//�����жϻص�
	// �ж����ȼ���������ǰ�ж����ȼ�����Ϊ2(NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2))�Ѿ����壬��Ҫ�޸�
	NVIC_InitStructure.NVIC_IRQChannel = USART2_IRQn;		  // ָ�������ĸ��ж�
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 3; // ��ռ���ȼ�Ϊ3
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;		  // �����ȼ�3
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;			  // IRQͨ��ʹ��
	NVIC_Init(&NVIC_InitStructure);							  // ���� NVIC

	/********************UART Config*****************************/
	USART_InitStructure.USART_BaudRate = 115200;									// ���ò�����
	USART_InitStructure.USART_WordLength = USART_WordLength_8b;						// 8bits����λ
	USART_InitStructure.USART_StopBits = USART_StopBits_1;							// 1bitֹͣλ
	USART_InitStructure.USART_Parity = USART_Parity_No;								// ����żУ��λ
	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None; // ��ʹ��Ӳ������
	USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;					// ���ͽ��վ�ʹ��

	USART_Init(USART2, &USART_InitStructure); // ������Ч

	USART_ITConfig(USART2, USART_IT_RXNE, ENABLE); // ʹ�ܴ��ڽ����ж�
	USART_ITConfig(USART2, USART_IT_IDLE, ENABLE);
	USART_Cmd(USART2, ENABLE);

	memset(&_uart_buf, 0, sizeof(Uart_Buffer_t));
	return 0;
}

void tb05_hal_send(char *ch, int len)
{
	int i = 0;
	printf("Json_pack_test, JSON: %s\r\nLength: %d\r\n", ch, len);
	for (i = 0; i < len; i++)
	{
		USART_SendData(USART2, (uint8_t)ch[i]);
	}
}
