#include "stm32f10x.h"
#include "delay.h"
#include "HAL_uart.h"
#include "stdio.h"
#include "stm32f10x_it.h"
#include "project_config.h"
#include "tb05_control.h"
#include "UART_FIFO.h"
#include "sx127x_cmd_process.h"

/*
wiring setting
spi bus:
	LoRa modules		STM32
	NSS_PIN					PA4
	MOSI_PIN      	PA7
	MISO_PIN     		PA6
	SCK_PIN       	PA5
	DIO0_PIN				PB0
	DIO1_PIN  			PB1
	RESET_PIN  			PB14
	DIO4_BUSY_PIN   PA0

UART:
	USB to TTL			STM32
	Tx							PA_3
	Rx							PA_2
*/

void sys_startup_log(void){
	printf("Compile Time: %s %s\r\n",__DATE__,__TIME__);
	printf("FW_version:%s\r\n",SOFT_VERSION);
	printf("company: Aithinker|B&T\r\n");
}

//sys peripharl
void SysInit(void) {
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);

	HALUart1Init();
	HALUart2Init();
	sys_startup_log();
	SysTick_Config(SystemCoreClock/1000);
	tb05_init();
	LoRa_init_process();
}

int main(void) {
	SysInit();
	while (1)
	{
		tb05_data_proccess();
		LoRa_IRQ_Handle();
		delay_ms(1);
	}
}
