#ifndef __CMD_PROCESS_H__
#define __CMD_PROCESS_H__

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "stm32f10x.h"
#include "project_config.h"

#if defined(__CC_ARM)
#pragma anon_unions
#endif
#define RX_BUF_MAX_LEN 2048
extern struct STRUCT_USART_Fram
{
    char Data_RX_BUF[RX_BUF_MAX_LEN];
    union
    {
        __IO u16 InfAll;
        struct
        {
            __IO u16 FramLength : 15;
            __IO u16 FramFinishFlag : 1;
        } InfBit;
    };

} TB05_Fram_Record_Struct;

void LoRa_cmd_process(void);
void LoRa_init_process(void);
void LoRa_IRQ_Handle(void);

#endif // end of __LoRa_EXAMPLE_SEND_H__
