#include "HAL_SPI.h"
#include "project_config.h"

//SPIʼ(sx126xsx127xʹõSPIͬģͳһʼ)
uint8_t Spi1Init(void){
	GPIO_InitTypeDef  GPIO_InitStructure;
	SPI_InitTypeDef  SPI_InitStructure;

	//ʼSPI
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1,ENABLE);//SPIʱʹ
	//ʼMISO,MOSI,SCKΪģʽ
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	    //ʹָ˿ʱ
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;	 //IOٶΪ50MHzﲻôΣֱдٶ50MHZ
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_AF_PP;	//Ƭģʽ
	GPIO_InitStructure.GPIO_Pin = RADIO_SCK_PIN|RADIO_MISO_PIN|RADIO_MOSI_PIN;
	GPIO_Init(RADIO_SCK_PORT, &GPIO_InitStructure);	//ʼGPIO

	//SPI
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;  //SPI˫ģʽ:SPIΪ˫˫ȫ˫
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;		//SPIģʽ:ΪSPI
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;		//SPIݴС:SPIͽ8λ֡ṹ
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;		//ʱӼ(ͬʱӵĿ״̬Ϊߵƽǵ͵ƽ)
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;	//λ(ͬʱӵĵڼأ½ݱ)
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;		//NSSźӲNSSܽţʹSSIλ:Ϊ(SSI)
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_32;		//岨ԤƵֵ:ԤƵֵΪ256(256,֮ٶ,ٶȹ쵼ͨʧٵС)
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;	//ָݴMSBλLSBλʼ:ݴMSBλʼ
	SPI_InitStructure.SPI_CRCPolynomial = 7;	//CRCֵĶʽ(CRCУ)
	SPI_Init(SPI1,&SPI_InitStructure);  //SPI_InitStructָĲʼSPIxĴ

	SPI_Cmd(SPI1,ENABLE); //ʹSPI
	
	//ʼNSSΪߵƽ RADIO_NSS_PIN		RADIO_NSS_PORT
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	    //ʹָ˿ʱ
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;	 //IOٶΪ50MHzﲻôΣֱдٶ50MHZ
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_PP;	//
	GPIO_InitStructure.GPIO_Pin = RADIO_NSS_PIN;
	GPIO_Init(RADIO_NSS_PORT, &GPIO_InitStructure);	//ʼGPIO
	//GPIO_ResetBits(gpioObj->portIndex,gpioObj->pinIndex);	//͵ƽ
	GPIO_SetBits(RADIO_NSS_PORT,RADIO_NSS_PIN);	//ߵƽ
	
	return 0;
}

//spi(ֵǽյ)
//
//     spiName	:Ҫͨĸspi
//     data		:Ҫ͵
//ֵ
//       յ
//ע⣺ûпCSźţҪԼƣͨһͨGPIOƾͿԣ
uint8_t HALSpi1InOut(uint8_t data){
	uint32_t retry=0;				 	
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_TXE) == RESET){//ָSPI־λ:ͻձ־λ(˾ͿԿ)
		if((retry++)>2000){
			//ʱ
			return 0xff;
		}
	}
	SPI_I2S_SendData(SPI1, data); //ͨSPIxһ
	retry=0;

	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_RXNE) == RESET){ //ָSPI־λ:ܻǿձ־λǿ˾ͱʾˣ
		if((retry++)>2000){
			//ʱ
			return 0xff;
		}
	}
	return SPI_I2S_ReceiveData(SPI1); //ͨSPIxյ	
}
