#include "stm32f10x.h"
#include "delay.h"
#include "HAL_uart.h"
#include "stdio.h"
#include "stm32f10x_it.h"
#include "project_config.h"
#include "sx126x_example_send.h"
#include "sx126x_example_recive.h"



/*
wiring setting
spi bus:
	LoRa modules		STM32
	NSS_PIN				PA4
	MOSI_PIN      		PA7
	MISO_PIN     		PA6
	SCK_PIN       		PA5
	RESET_PIN    		PB1
	DIO1_PIN      		PB11
	DIO4_BUSY_PIN      	PA0

UART:
	USB to TTL			STM32
	Tx					PA_9
	Rx					PA_10
*/

static void LORA_LED_init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Pin = GREEN_LED_PIN;
	GPIO_Init(GREEN_LED_PORT, &GPIO_InitStructure);

	GPIO_WriteBit(GREEN_LED_PORT, GREEN_LED_PIN, Bit_RESET);
}

//Ӳʼ
void SysInit(void){

	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);	//NVIC(жȼ),ע:ֻһ,úҪ޸,ֺܶ ֱ4,0~15ȼ
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);	    //JTAGΪGPIOҪʹ RCC_APB2Periph_AFIO ʱ
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable,ENABLE);	//رJTAG(Ҫ RCC_APB2Periph_AFIO ʱ)

	//ledָʾ
	LORA_LED_init();
	
	HALUart1Init();
	SysTick_Config(SystemCoreClock/1000);
}

int main(void){
	SysInit();	//Ӳʼ
	
	printf("SysInit OK,version:%s\r\n",SOFT_VERSION);

	//demoһֻܴһdemodemo󽫽ѭ᷵
	//궨project_config.hļ޸ģĬΪģʽ
	#if LORA_DATA_SEND_OR_RECEIV_MODE
	ExampleSX126xSendDemo();	//ʱdemo
	#else
	ExampleSX126xReciveDemo();	//ѭdemo
	#endif 
	
	//demoִв
	while(1){
		printf("systick=%d\r\n",Get_SysTick());
		GPIO_ResetBits(GREEN_LED_PORT,GREEN_LED_PIN);
		delay_ms(500);
		GPIO_SetBits(GREEN_LED_PORT,GREEN_LED_PIN);
		delay_ms(500);
	}
}
